/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.gui;

import com.google.common.collect.Lists;
import com.tom.storagemod.StorageMod;
import com.tom.storagemod.StoredItemStack;
import com.tom.storagemod.gui.ContainerStorageTerminal;
import com.tom.storagemod.jei.IJEIAutoFillTerminal;
import com.tom.storagemod.network.IDataReceiver;
import com.tom.storagemod.tile.TileEntityCraftingTerminal;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.client.util.RecipeBookCategories;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.item.crafting.ServerRecipePlacer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ContainerCraftingTerminal
extends ContainerStorageTerminal
implements IJEIAutoFillTerminal,
IDataReceiver {
    private static Field recipeItemHelperField;
    private final CraftingInventory craftMatrix;
    private final CraftResultInventory craftResult;
    private Slot craftingResultSlot;
    private final List<IContainerListener> listeners = Lists.newArrayList();

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        this.listeners.add(listener);
    }

    public void func_82847_b(IContainerListener listener) {
        super.func_82847_b(listener);
        this.listeners.remove(listener);
    }

    public ContainerCraftingTerminal(int id, PlayerInventory inv, TileEntityCraftingTerminal te) {
        super(StorageMod.craftingTerminalCont, id, inv, te);
        this.craftMatrix = te.getCraftingInv();
        this.craftResult = te.getCraftResult();
        this.init();
        this.addPlayerSlots(inv, 8, 174);
        te.registerCrafting(this);
    }

    public ContainerCraftingTerminal(int id, PlayerInventory inv) {
        super(StorageMod.craftingTerminalCont, id, inv);
        this.craftMatrix = new CraftingInventory((Container)this, 3, 3);
        this.craftResult = new CraftResultInventory();
        this.init();
        this.addPlayerSlots(inv, 8, 174);
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        if (this.te != null) {
            ((TileEntityCraftingTerminal)this.te).unregisterCrafting(this);
        }
    }

    private void init() {
        int x = -4;
        int y = 94;
        this.craftingResultSlot = new CraftingResultSlot(this.pinv.field_70458_d, this.craftMatrix, (IInventory)this.craftResult, 0, x + 124, y + 35){

            public ItemStack func_190901_a(PlayerEntity thePlayer, ItemStack stack) {
                if (thePlayer.field_70170_p.field_72995_K) {
                    return ItemStack.field_190927_a;
                }
                this.func_75208_c(stack);
                if (!ContainerCraftingTerminal.this.pinv.field_70458_d.func_130014_f_().field_72995_K) {
                    ((TileEntityCraftingTerminal)ContainerCraftingTerminal.this.te).craft(thePlayer);
                }
                return ItemStack.field_190927_a;
            }
        };
        this.func_75146_a(this.craftingResultSlot);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.func_75146_a(new SlotCrafting((IInventory)this.craftMatrix, j + i * 3, x + 30 + j * 18, y + 17 + i * 18));
            }
        }
    }

    @Override
    protected void addStorageSlots() {
        this.addStorageSlots(5, 8, 18);
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return slotIn.field_75224_c != this.craftResult && super.func_94530_a(stack, slotIn);
    }

    @Override
    public ItemStack shiftClickItems(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 0) {
                if (this.te == null) {
                    return ItemStack.field_190927_a;
                }
                ((TileEntityCraftingTerminal)this.te).craftShift(playerIn);
                if (!playerIn.field_70170_p.field_72995_K) {
                    this.func_75142_b();
                }
                return ItemStack.field_190927_a;
            }
            if (index > 0 && index < 10) {
                if (this.te == null) {
                    return ItemStack.field_190927_a;
                }
                ItemStack stack = ((TileEntityCraftingTerminal)this.te).pushStack(itemstack);
                slot.func_75215_d(stack);
                if (!playerIn.field_70170_p.field_72995_K) {
                    this.func_75142_b();
                }
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return ItemStack.field_190927_a;
    }

    public void onCraftMatrixChanged() {
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            Slot slot = (Slot)this.field_75151_b.get(i);
            if (!(slot instanceof SlotCrafting) && slot != this.craftingResultSlot) continue;
            for (IContainerListener listener : this.listeners) {
                if (!(listener instanceof ServerPlayerEntity)) continue;
                ((ServerPlayerEntity)listener).field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(this.field_75152_c, i, slot.func_75211_c()));
            }
        }
    }

    public boolean func_75140_a(PlayerEntity playerIn, int id) {
        if (this.te != null && id == 0) {
            ((TileEntityCraftingTerminal)this.te).clear();
        } else {
            super.func_75140_a(playerIn, id);
        }
        return false;
    }

    @Override
    public void func_201771_a(RecipeItemHelper itemHelperIn) {
        this.craftMatrix.func_194018_a(itemHelperIn);
    }

    @Override
    public void func_201768_e() {
        this.craftMatrix.func_174888_l();
        this.craftResult.func_174888_l();
    }

    @Override
    public boolean func_201769_a(IRecipe<? super CraftingInventory> recipeIn) {
        return recipeIn.func_77569_a((IInventory)this.craftMatrix, this.pinv.field_70458_d.field_70170_p);
    }

    @Override
    public int func_201767_f() {
        return 0;
    }

    @Override
    public int func_201770_g() {
        return this.craftMatrix.func_174922_i();
    }

    @Override
    public int func_201772_h() {
        return this.craftMatrix.func_174923_h();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int func_203721_h() {
        return 10;
    }

    public List<RecipeBookCategories> getRecipeBookCategories() {
        return Lists.newArrayList((Object[])new RecipeBookCategories[]{RecipeBookCategories.CRAFTING_SEARCH, RecipeBookCategories.CRAFTING_EQUIPMENT, RecipeBookCategories.CRAFTING_BUILDING_BLOCKS, RecipeBookCategories.CRAFTING_MISC, RecipeBookCategories.CRAFTING_REDSTONE});
    }

    public void func_217056_a(boolean p_217056_1_, IRecipe<?> p_217056_2_, ServerPlayerEntity p_217056_3_) {
        new ServerRecipePlacer(this){
            {
                try {
                    recipeItemHelperField.set((Object)this, (Object)new TerminalRecipeItemHelper());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            protected void func_194325_a(Slot slotToFill, ItemStack ingredientIn) {
                StoredItemStack st;
                int i = this.field_201514_c.func_194014_c(ingredientIn);
                if (i != -1) {
                    ItemStack itemstack = this.field_201514_c.func_70301_a(i).func_77946_l();
                    if (!itemstack.func_190926_b()) {
                        if (itemstack.func_190916_E() > 1) {
                            this.field_201514_c.func_70298_a(i, 1);
                        } else {
                            this.field_201514_c.func_70304_b(i);
                        }
                        itemstack.func_190920_e(1);
                        if (slotToFill.func_75211_c().func_190926_b()) {
                            slotToFill.func_75215_d(itemstack);
                        } else {
                            slotToFill.func_75211_c().func_190917_f(1);
                        }
                    }
                } else if (ContainerCraftingTerminal.this.te != null && (st = ContainerCraftingTerminal.this.te.pullStack(new StoredItemStack(ingredientIn), 1L)) != null) {
                    if (slotToFill.func_75211_c().func_190926_b()) {
                        slotToFill.func_75215_d(st.getActualStack());
                    } else {
                        slotToFill.func_75211_c().func_190917_f(1);
                    }
                }
            }

            protected void func_201510_a(int slotIn) {
                ItemStack itemstack = this.field_201515_d.func_75139_a(slotIn).func_75211_c();
                if (!itemstack.func_190926_b()) {
                    PlayerEntity player = this.field_201514_c.field_70458_d;
                    InventoryHelper.func_180173_a((World)player.field_70170_p, (double)player.func_226277_ct_(), (double)(player.func_226278_cu_() - 5.0), (double)player.func_226281_cx_(), (ItemStack)itemstack);
                }
            }

            protected void func_201511_a() {
                ((TileEntityCraftingTerminal)ContainerCraftingTerminal.this.te).clear();
                this.field_201515_d.func_201768_e();
            }
        }.func_194327_a(p_217056_3_, p_217056_2_, p_217056_1_);
    }

    @Override
    public void receive(CompoundNBT message) {
        super.receive(message);
        if (message.func_74764_b("i")) {
            ItemStack[][] stacks = new ItemStack[9][];
            ListNBT list = message.func_150295_c("i", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT nbttagcompound = list.func_150305_b(i);
                byte slot = nbttagcompound.func_74771_c("s");
                int l = nbttagcompound.func_74771_c("l");
                stacks[slot] = new ItemStack[l];
                for (int j = 0; j < l; ++j) {
                    CompoundNBT tag = nbttagcompound.func_74775_l("i" + j);
                    stacks[slot][j] = ItemStack.func_199557_a((CompoundNBT)tag);
                }
            }
            ((TileEntityCraftingTerminal)this.te).handlerItemTransfer(this.pinv.field_70458_d, stacks);
        }
    }

    static {
        try {
            for (Field f : ServerRecipePlacer.class.getDeclaredFields()) {
                if (f.getType() != RecipeItemHelper.class) continue;
                f.setAccessible(true);
                recipeItemHelperField = f;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public class TerminalRecipeItemHelper
    extends RecipeItemHelper {
        public void func_194119_a() {
            super.func_194119_a();
            ContainerCraftingTerminal.this.itemList.forEach(e -> this.func_195932_a(e.getActualStack()));
        }
    }

    public static class SlotCrafting
    extends Slot {
        public SlotCrafting(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }
    }
}

